<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ProdottiDalNegozio {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato; 
        private $numeroProdotti; 
        private $dimensioneDivSingoloProdotto;
        private $categoria;
        private $categorieIndicate; 
        private $escludiCategoria;
        private $marca;
        private $escludiMarca;
        private $lingua;
        private $tipoVisualizzazione;
        private $tipoProdotti;
        private $aspetto;
        private $etichettaPulsanteAltriProdotti;
        private $linkPulsanteAltriProdotti;
        private $mostraTitoloComponente;
        private $mostraPrezzo;
        private $escludiProdottiEsauriti;
        private $mostraTesto;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $numeroProdotti=0, $dimensioneDivSingoloProdotto="", $categoria=0, $categorieIndicate="", $escludiCategoria="", $marca="", $escludiMarca="", $lingua="", $tipoVisualizzazione="", $tipoProdotti="", $aspetto="", $etichettaPulsanteAltriProdotti="", $linkPulsanteAltriProdotti = "", $mostraTitoloComponente="", $mostraPrezzo="", $escludiProdottiEsauriti="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->numeroProdotti = $numeroProdotti;
            $this->dimensioneDivSingoloProdotto = $dimensioneDivSingoloProdotto;
            $this->categoria = $categoria;
            $this->categorieIndicate = $categorieIndicate;
            $this->escludiCategoria = $escludiCategoria;
            $this->marca        = $marca;
            $this->escludiMarca = $escludiMarca;
            $this->tipoProdotti = $tipoProdotti;
            $this->aspetto      = $aspetto;
            $this->lingua       = $lingua;
            $this->etichettaPulsanteAltriProdotti = $etichettaPulsanteAltriProdotti;
            $this->linkPulsanteAltriProdotti = $linkPulsanteAltriProdotti;
            $this->mostraTitoloComponente = $mostraTitoloComponente;
            $this->mostraPrezzo = $mostraPrezzo;
            $this->escludiProdottiEsauriti = $escludiProdottiEsauriti;
        }

        function crea() {
            $query = "INSERT INTO geecEc_righeProdotti VALUES(NULL, '$this->nome', '$this->spazioOccupato','$this->numeroProdotti','$this->dimensioneDivSingoloProdotto', '$this->tipoVisualizzazione', '$this->tipoProdotti', '$this->aspetto', '$this->lingua', '$this->etichettaPulsanteAltriProdotti', '$this->linkPulsanteAltriProdotti', '$this->mostraTitoloComponente','$this->mostraPrezzo','$this->escludiProdottiEsauriti','$this->categoria','$this->categorieIndicate','$this->escludiCategoria','$this->marca')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query = "UPDATE geecEc_righeProdotti SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', numeroProdotti='$this->numeroProdotti', categoria='$this->categoria', dimensioneDivSingoloProdotto='$this->dimensioneDivSingoloProdotto', categorieIndicate='$this->categorieIndicate', escludiCategoria='$this->escludiCategoria', lingua='$this->lingua', tipoVisualizzazione='$this->tipoVisualizzazione', tipoProdotti='$this->tipoProdotti', aspetto='$this->aspetto', etichettaPulsanteAltriProdotti='$this->etichettaPulsanteAltriProdotti', linkPulsanteAltriProdotti='$this->linkPulsanteAltriProdotti', mostraTitoloComponente='$this->mostraTitoloComponente', mostraPrezzo='$this->mostraPrezzo', marca='$this->marca', escludiMarca='$this->escludiMarca' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecEc_righeProdotti",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 39
            $queryEliminaOccorrenzeComposizionePagine = "DELETE FROM geecB_composizionePagine WHERE idElemento = $this->id AND idComponente = 39";
            $this->db->eseguiQueryScrittura($queryEliminaOccorrenzeComposizionePagine);
        }
        
        function duplica() {
            $query    = "INSERT INTO geecEc_righeProdotti VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiComponente WHERE idOccorenza='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiComponente` (`id`, `idOccorenza`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiProdottiDalNegozio = $this->db->leggiSingolaRiga("geecEc_righeProdotti",$this->id);
            $this->nome                           = $datiProdottiDalNegozio["nome"];
            $this->spazioOccupato                 = $datiProdottiDalNegozio["spazioOccupato"];
            $this->numeroProdotti                 = $datiProdottiDalNegozio["numeroProdotti"];
            $this->dimensioneDivSingoloProdotto   = $datiProdottiDalNegozio["dimensioneDivSingoloProdotto"];
            $this->categoria                      = $datiProdottiDalNegozio["categoria"];
            $this->categorieIndicate              = $datiProdottiDalNegozio["categorieIndicate"];
            $this->escludiCategoria               = $datiProdottiDalNegozio["escludiCategoria"];
            $this->lingua                         = $datiProdottiDalNegozio["lingua"];
            $this->tipoVisualizzazione            = $datiProdottiDalNegozio["tipoVisualizzazione"];
            $this->tipoProdotti                   = $datiProdottiDalNegozio["tipoProdotti"];
            $this->aspetto                        = $datiProdottiDalNegozio["aspetto"];
            $this->etichettaPulsanteAltriProdotti = $datiProdottiDalNegozio["etichettaPulsanteAltriProdotti"];
            $this->linkPulsanteAltriProdotti      = $datiProdottiDalNegozio["linkPulsanteAltriProdotti"];
            $this->mostraTitoloComponente         = $datiProdottiDalNegozio["mostraTitoloComponente"];
            $this->mostraPrezzo                   = $datiProdottiDalNegozio["mostraPrezzo"];
            $this->escludiProdottiEsauriti        = $datiProdottiDalNegozio["escludiProdottiEsauriti"];
            $this->marca                          = $datiProdottiDalNegozio["marca"];
            $this->escludiMarca                   = $datiProdottiDalNegozio["escludiMarca"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getNumeroProdotti() {
            return $this->numeroProdotti;
        }

        public function getDimensioneDivSingoloProdotto() {
            return $this->dimensioneDivSingoloProdotto;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getCategorieIndicate() {
            return $this->categorieIndicate;
        }

        public function getEscludiCategoria() {
            return $this->escludiCategoria;
        }

        public function getLingua() {
            return $this->lingua;
        }
        
        public function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }

        public function getTipoProdotti() {
            return $this->tipoProdotti;
        }

        public function getAspetto() {
            return $this->aspetto;
        }

        public function getEtichettaPulsanteAltriProdotti() {
            return $this->etichettaPulsanteAltriProdotti;
        }

        public function getLinkPulsanteAltriProdotti() {
            return $this->linkPulsanteAltriProdotti;
        }

        public function getMostraTitoloComponente() {
            return $this->mostraTitoloComponente;
        }

        public function getMostraTesto() {
            return $this->mostraTesto;
        }

        public function getMostraPrezzo() {
            return $this->mostraPrezzo;
        }
        
        public function getEscludiProdottiEsauriti() {
            return $this->escludiProdottiEsauriti;
        }
        
        public function getMarca() {
            return $this->marca;
        }

        public function getEscludiMarca() {
            return $this->escludiMarca;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setNumeroProdotti($numeroProdotti) {
            $this->numeroProdotti = $numeroProdotti;
        }

        public function setDimensioneDivSingoloProdotto($dimensioneDivSingoloProdotto) {
            $this->dimensioneDivSingoloProdotto = $dimensioneDivSingoloProdotto;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        public function setCategorieIndicate($categorieIndicate): void {
            $this->categorieIndicate = $categorieIndicate;
        }

        public function setEscludiCategoria($escludiCategoria): void {
            $this->escludiCategoria = $escludiCategoria;
        }

        public function setLingua($lingua): void {
            $this->lingua = $lingua;
        }

        public function setTipoVisualizzazione($tipoVisualizzazione): void {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }

        public function setTipoProdotti($tipoProdotti): void {
            $this->tipoProdotti = $tipoProdotti;
        }
        
        public function setAspetto($aspetto): void {
            $this->aspetto = $aspetto;
        }
        
        public function setEtichettaPulsanteAltriProdotti($etichettaPulsanteAltriProdotti): void {
            $this->etichettaPulsanteAltriProdotti = $etichettaPulsanteAltriProdotti;
        }

        public function setLinkPulsanteAltriProdotti($linkPulsanteAltriProdotti): void {
            $this->linkPulsanteAltriProdotti = $linkPulsanteAltriProdotti;
        }
        
        public function setMostraTitoloComponente($mostraTitoloComponente): void {
            $this->mostraTitoloComponente = $mostraTitoloComponente;
        }

        public function setMostraTesto($mostraTesto): void {
            $this->mostraTesto = $mostraTesto;
        }

        public function setMostraPrezzo($mostraPrezzo): void {
            $this->mostraPrezzo = $mostraPrezzo;
        }
        
        public function setEscludiProdottiEsauriti($escludiProdottiEsauriti): void {
            $this->escludiProdottiEsauriti = $escludiProdottiEsauriti;
        }
        
        public function setMarca($marca): void {
            $this->marca = $marca;
        }
        
        public function setEscludiMarca($escludiMarca): void {
            $this->escludiMarca = $escludiMarca;
        }
    }